# HRMS Plugin - Responsive Testing Guide

## Quick Testing Checklist

### 🖥️ Desktop Testing (1920px - 1200px)
- [ ] Dashboard loads with 4-column stat cards
- [ ] All tables display without horizontal scroll
- [ ] Sidebar navigation is visible and functional
- [ ] Forms display in 2-3 column grids
- [ ] Modals are centered with appropriate width
- [ ] Buttons have proper spacing and sizing
- [ ] Hover effects work correctly
- [ ] No layout overflow or breaking

### 💻 Laptop Testing (1200px - 768px)
- [ ] Stat cards adjust to 2-3 columns
- [ ] Tables remain readable
- [ ] Forms adapt to 2 columns
- [ ] Navigation remains accessible
- [ ] Buttons maintain proper sizing
- [ ] Modals adjust to screen width
- [ ] No horizontal scrolling on main content

### 📱 Tablet Testing (1024px - 640px)
- [ ] Sidebar converts to horizontal navigation
- [ ] Stat cards display in 2 columns
- [ ] Forms collapse to single column
- [ ] Tables scroll horizontally
- [ ] Touch targets are at least 44px
- [ ] Modals are 90% width
- [ ] Filter bars stack vertically
- [ ] Action buttons are touch-friendly

### 📱 Mobile Testing (640px - 320px)
- [ ] All stat cards stack vertically (1 column)
- [ ] Navigation is accessible and touch-friendly
- [ ] Forms are single column
- [ ] Input fields are at least 48px tall
- [ ] Buttons are full-width or properly sized
- [ ] Modals are full-screen or bottom sheet
- [ ] Tables scroll horizontally smoothly
- [ ] Text is readable (minimum 14px)
- [ ] No pinch-zoom required
- [ ] Touch targets are at least 44px

## Module-Specific Testing

### 1. Dashboard Module

#### Desktop (1920px)
```
✓ 4 stat cards in a row
✓ Team list and task summary side-by-side
✓ Charts display full width
✓ All widgets visible
```

#### Tablet (768px)
```
✓ 2 stat cards per row
✓ Team list and task summary stack
✓ Charts remain readable
✓ Navigation becomes horizontal tabs
```

#### Mobile (375px)
```
✓ 1 stat card per row
✓ All sections stack vertically
✓ Charts scale appropriately
✓ Navigation is touch-friendly
```

### 2. Employee Management

#### Desktop
```
✓ Add Employee button in header
✓ Filter bar with search and filters inline
✓ Employee table with all columns visible
✓ Action buttons (Edit, Delete) properly sized
✓ Add/Edit modal centered, max-width 600px
```

#### Tablet
```
✓ Filter bar elements wrap appropriately
✓ Some table columns may be hidden (.hide-mobile)
✓ Action buttons remain accessible
✓ Modal is 90% width
```

#### Mobile
```
✓ Add Employee button full-width
✓ Filter bar stacks vertically
✓ Table scrolls horizontally
✓ Action buttons stack in table cells
✓ Modal is full-screen or bottom sheet
✓ Form fields are single column
```

### 3. Attendance Module

#### Desktop
```
✓ Bulk Attendance button visible
✓ Calendar view displays properly
✓ Attendance table with all columns
✓ Date pickers work correctly
```

#### Tablet
```
✓ Buttons wrap to new line if needed
✓ Calendar remains functional
✓ Table scrolls if needed
```

#### Mobile
```
✓ Bulk Attendance button full-width
✓ Calendar is touch-friendly
✓ Table scrolls horizontally
✓ Date pickers are mobile-optimized
✓ Status badges are readable
```

### 4. Payroll Module

#### Desktop (1920px)
```
✓ 4 payroll stat cards in a row
✓ 3 quick action cards in a row
✓ Navigation tabs inline
✓ Payroll table with all columns
✓ Generate Payroll button prominent
```

#### Tablet (768px)
```
✓ 2 stat cards per row
✓ 2 quick action cards per row
✓ Navigation tabs scroll if needed
✓ Table scrolls horizontally
✓ Filter bar stacks
```

#### Mobile (375px)
```
✓ 1 stat card per row
✓ 1 quick action card per row
✓ Navigation tabs scroll horizontally
✓ Table scrolls smoothly
✓ All buttons are touch-friendly
✓ Salary structure forms single column
```

### 5. Employee Portal

#### Desktop
```
✓ Sidebar navigation on left
✓ Content area on right
✓ 3 stat cards in overview
✓ Attendance timer centered
✓ Check-in/out buttons properly sized
```

#### Tablet
```
✓ Sidebar becomes horizontal navigation
✓ Content full-width below nav
✓ 2 stat cards per row
✓ Attendance timer scales down
```

#### Mobile
```
✓ Navigation stacks or uses grid
✓ All content full-width
✓ 1 stat card per row
✓ Attendance timer smaller (200px)
✓ Check-in/out buttons full-width
✓ History table scrolls horizontally
```

## Device-Specific Testing

### iPhone Testing

#### iPhone 14 Pro Max (430px × 932px)
```
✓ Safe area insets respected
✓ No content behind notch
✓ Bottom bar doesn't overlap content
✓ Landscape mode works correctly
```

#### iPhone 14 Pro (393px × 852px)
```
✓ All touch targets accessible
✓ Text is readable
✓ Forms work without zoom
✓ Modals slide up from bottom
```

#### iPhone SE (375px × 667px)
```
✓ Compact layout works
✓ Navigation is accessible
✓ Buttons are properly sized
✓ Content doesn't overflow
```

### iPad Testing

#### iPad Pro 12.9" (1024px × 1366px)
```
✓ Tablet layout activated
✓ Horizontal navigation works
✓ Content uses available space
✓ Touch targets are adequate
```

#### iPad Air (820px × 1180px)
```
✓ Layout adapts correctly
✓ Forms are usable
✓ Tables scroll smoothly
```

### Android Testing

#### Samsung Galaxy S23 (360px × 800px)
```
✓ Layout works correctly
✓ Touch targets are adequate
✓ Text is readable
✓ No horizontal scroll
```

#### Google Pixel 7 (412px × 915px)
```
✓ All features accessible
✓ Buttons work correctly
✓ Forms are usable
```

## Orientation Testing

### Portrait to Landscape
```
✓ Layout adjusts smoothly
✓ No content is cut off
✓ Modals remain accessible
✓ Navigation remains functional
✓ No JavaScript errors
```

### Landscape Optimizations
```
✓ Modals have max-height (90vh)
✓ Sidebar becomes static
✓ Attendance timer scales down
✓ Content remains scrollable
```

## Browser-Specific Testing

### Chrome (Desktop & Mobile)
```
✓ All CSS features work
✓ Grid layouts display correctly
✓ Flexbox works as expected
✓ Animations are smooth
✓ Touch events work on mobile
```

### Safari (Desktop & Mobile)
```
✓ Webkit prefixes work
✓ Safe area insets respected
✓ Smooth scrolling works
✓ Form inputs don't zoom
✓ Backdrop filters work
```

### Firefox (Desktop & Mobile)
```
✓ Grid layouts work
✓ Flexbox works correctly
✓ Scrollbar styling works
✓ All features functional
```

### Edge (Desktop)
```
✓ All modern CSS works
✓ Grid and flexbox work
✓ No layout issues
```

## Accessibility Testing

### Keyboard Navigation
```
✓ Tab order is logical
✓ Focus indicators visible
✓ All interactive elements accessible
✓ Modals can be closed with Esc
✓ Forms can be submitted with Enter
```

### Screen Reader Testing
```
✓ Headings are properly structured
✓ Form labels are associated
✓ Buttons have descriptive text
✓ Tables have proper headers
✓ ARIA labels where needed
```

### Touch Accessibility
```
✓ Minimum 44px touch targets
✓ Adequate spacing between elements
✓ Swipe gestures work
✓ Long press works where needed
```

## Performance Testing

### Mobile Performance
```
✓ Page loads in < 3 seconds
✓ Animations are smooth (60fps)
✓ Scrolling is smooth
✓ No layout shifts
✓ Images are optimized
```

### Network Conditions
```
✓ Works on 3G
✓ Works on 4G
✓ Works on WiFi
✓ Graceful degradation on slow connections
```

## Common Issues & Solutions

### Issue: Text too small on mobile
**Solution**: Ensure minimum 14px font size for body text

### Issue: Buttons too small to tap
**Solution**: Minimum 44px × 44px touch targets

### Issue: Horizontal scroll on mobile
**Solution**: Check for fixed widths, use max-width: 100%

### Issue: Modal not visible on mobile
**Solution**: Check z-index and positioning

### Issue: Form inputs zoom on iOS
**Solution**: Use minimum 16px font size for inputs

### Issue: Table breaks layout
**Solution**: Wrap in `.hrm-table-wrapper` with overflow-x: auto

### Issue: Sidebar overlaps content
**Solution**: Check responsive breakpoints and flex/grid settings

## Testing Tools

### Browser DevTools
- **Chrome DevTools**: Device Mode, Responsive Design
- **Firefox DevTools**: Responsive Design Mode
- **Safari DevTools**: Responsive Design Mode

### Online Tools
- **BrowserStack**: Real device testing
- **Responsively App**: Multi-device preview
- **LambdaTest**: Cross-browser testing

### Physical Devices
- Test on at least one real mobile device
- Test on at least one real tablet
- Test on different screen sizes

## Automated Testing Commands

### Visual Regression Testing
```bash
# Install dependencies
npm install --save-dev puppeteer

# Run visual tests
npm run test:visual
```

### Responsive Screenshot Generation
```bash
# Generate screenshots at different breakpoints
npm run screenshots
```

## Sign-Off Checklist

Before marking responsive implementation as complete:

### ✅ All Modules Tested
- [ ] Dashboard
- [ ] Employee Management
- [ ] Attendance
- [ ] Payroll
- [ ] Reports
- [ ] Employee Portal
- [ ] Settings

### ✅ All Breakpoints Tested
- [ ] 1920px (Full HD)
- [ ] 1440px (Laptop)
- [ ] 1024px (Tablet Landscape)
- [ ] 768px (Tablet Portrait)
- [ ] 375px (Mobile)
- [ ] 320px (Small Mobile)

### ✅ All Browsers Tested
- [ ] Chrome Desktop
- [ ] Chrome Mobile
- [ ] Safari Desktop
- [ ] Safari Mobile (iOS)
- [ ] Firefox Desktop
- [ ] Firefox Mobile
- [ ] Edge Desktop

### ✅ All Orientations Tested
- [ ] Portrait mode
- [ ] Landscape mode
- [ ] Orientation change

### ✅ Accessibility Verified
- [ ] Keyboard navigation
- [ ] Screen reader compatibility
- [ ] Touch target sizes
- [ ] Color contrast

### ✅ Performance Verified
- [ ] Fast load times
- [ ] Smooth animations
- [ ] No layout shifts
- [ ] Optimized images

## Reporting Issues

When reporting responsive issues, include:

1. **Device**: iPhone 14 Pro, iPad Air, etc.
2. **Screen Size**: 393px × 852px
3. **Browser**: Safari 16.0
4. **Orientation**: Portrait/Landscape
5. **Module**: Payroll, Dashboard, etc.
6. **Screenshot**: Visual evidence
7. **Expected Behavior**: What should happen
8. **Actual Behavior**: What actually happens

## Conclusion

This testing guide ensures comprehensive coverage of all responsive features. Follow this checklist systematically to verify that the HRMS plugin works perfectly across all devices and screen sizes.

**Testing Status**: ✅ Ready for comprehensive testing
**Last Updated**: 2026-01-23
**Version**: 1.0.0
